DROP PROCEDURE [hips].[VisitorHospitalGenerate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Kirby
-- Create date:   18 October 2013
-- Description:   Generates or updates visitor hospitals based 
--				  on the Health Provider organisation data
-- =============================================
CREATE PROCEDURE [hips].[VisitorHospitalGenerate]
    (
      @UserModified VARCHAR(256)
    )
AS 
    BEGIN
        SET NOCOUNT ON

	-- Update the name of any exisiting Visitor Hospitals
        UPDATE  [hips].[Hospital]
        SET     [Description] = hpo.[Name] + '_Visitor' ,
                [Name] = hpo.[Name] + '_Visitor' ,
                [DateModified] = GETDATE() ,
                [UserModified] = @UserModified
        FROM    [hips].[HealthProviderOrganisation] hpo
                INNER JOIN [hips].[Hospital] h ON h.HospitalId = hpo.VisitorHospitalId

	-- Insert new Visitor Hospital records into the Hospital table  
        INSERT  [hips].[Hospital]
                ( [Description] ,
                  [Name] ,
                  [HealthProviderOrganisationId] ,
                  [UploadDocumentMinimumAge],
                  [DateCreated] ,
                  [UserCreated] ,
                  [DateModified] ,
                  [UserModified]
		        )
                SELECT  [Name] + '_Visitor' AS [Description] ,
                        [Name] + '_Visitor' AS [Name] ,
                        [HealthProviderOrganisationId] ,
                        0,
                        GETDATE() ,
                        @UserModified ,
                        GETDATE() ,
                        @UserModified
                FROM    [hips].[HealthProviderOrganisation]
                WHERE   VisitorHospitalId IS NULL 

	-- Update the Health Provider Organisation to link to the new Visitor Hospital records
        UPDATE  [hips].[HealthProviderOrganisation]
        SET     VisitorHospitalId = h.HospitalId ,
                [DateModified] = GETDATE() ,
                [UserModified] = @UserModified
        FROM    [hips].[HealthProviderOrganisation] hpo
                INNER JOIN [hips].[Hospital] h ON h.Name = hpo.Name
                                                  + '_Visitor'
        WHERE   VisitorHospitalId IS NULL 

    END
GO

